function [varargout]=matricesP22D(in)
% MATRICESP22D matrices for the P2-2D-elements on the reference element.
%   [MASSA,DERXX,DERYY,DERXY,DERX,DERY]=MATRICESP22D compute
%   the following local matrices: 
%
%   MASSA=(MASSA(I,J))=(Int(Tref) phiI*phiJ dT), I,J=1,...,6
%   DERWZ=(DERWZ(I,J))=(Int(Tref) d(phiI)/dw*d(phiJ)/dz dT), I,J=1,...,6
%   DERX=(DERX(I,J))=(Int(Tref) phiI*d(phiJ)/dx dT), I,J=1,...,6
%   DERY=(DERY(I,J))=(Int(Tref) phiI*d(phiJ)/dy dT), I,J=1,...,6
%
%   [MASSA]=MATRICESP22D compute only the mass matrix.
%   [MASSA,DERXX,DERYY,DERXY]=MATRICESP22D compute the mass and the
%   matrices connected with the sitffness matrix.
%   [MASSA,DERXX,DERYY,DERXY,DERX,DERY]=MATRICESP22D('L') as before,
%   but now the mass matrix MASSA is lumped ("diagonalized mass").

%      

if nargin == 0
    varargout(1) = {[ 1/60  -1/360 -1/360  0    -1/90  0;... 
                     -1/360  1/60  -1/360  0     0    -1/90;...
                     -1/360 -1/360  1/60  -1/90  0     0;...
                      0      0     -1/90   4/45  2/45  2/45; ...
                     -1/90   0      0      2/45  4/45  2/45;...
                      0     -1/90   0      2/45  2/45  4/45]}; 
else
    varargout(1) = {[1/19 0    0     0     0     0;... 
                     0    1/19 0     0     0     0;...
                     0    0    1/19  0     0     0;...
                     0    0    0     16/57 0     0; ...
                     0    0    0     0     16/57 0;...
                     0    0    0     0     0     16/57]/2}; 
    warning('For P2 elements only diagonalized mass-matrix is available');
end
 
varargout(2) = {[1/2  1/6  0 -2/3 0    0; ... 
                 1/6  1/2  0 -2/3 0    0; ...
		         0    0    0  0   0    0; ...
                -2/3 -2/3  0  4/3 0    0; ...
		         0    0    0  0   4/3 -4/3; ... 
                 0    0    0  0  -4/3  4/3]};
varargout(3) = {[1/2 0  1/6  0    0   -2/3; ...
                 0   0  0    0    0    0; ...
		         1/6 0  1/2  0    0   -2/3; ...
                 0   0  0    4/3 -4/3  0; ...
		         0   0  0   -4/3  4/3  0; ...
                -2/3 0 -2/3  0    0    4/3]};
varargout(4) = {[1/2 0  1/6  0    0   -2/3; ...
                 1/6 0 -1/6 -2/3  2/3  0; ...
		         0   0  0    0    0    0; ... 
                -2/3 0  0    2/3 -2/3  2/3; ...
		         0   0  2/3 -2/3  2/3 -2/3; ...
                 0   0 -2/3  2/3 -2/3  2/3]};
varargout(5) = {[-1/15 -1/30 0  1/10 -1/30  1/30; ...
                  1/30  1/15 0 -1/10 -1/30  1/30; ...
        		  1/30 -1/30 0  0     1/15 -1/15; ...
		         -1/10  1/10 0  0     2/15 -2/15; ...
		          1/30  1/10 0 -2/15  4/15 -4/15; ...
                 -1/10 -1/30 0  2/15  4/15 -4/15]};
varargout(6) = {[-1/15 0 -1/30  1/30 -1/30  1/10; ...
                  1/30 0 -1/30 -1/15  1/15  0; ...
                  1/30 0  1/15  1/30 -1/30 -1/10; ...
                 -1/10 0 -1/30 -4/15  4/15  2/15; ... 
                  1/30 0  1/10 -4/15  4/15 -2/15; ... 
                 -1/10 0  1/10 -2/15  2/15  0]};

return